	function csdc = TWO_C_2_CSDC(vals,dummy)
	
	% 	Converts a real two's-complement vector between -1 and 1 to a
	%	CSDC vector of wordlength n.	
	
	% 
	%	EXAMPLE TWO_C = 1001
	%	CSDC =  [ 0  1  0   0   0   0   -1   0   1   0   0   1]	
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 			Oscar Gustafsson
	% 	Modified by: 	 	LW 2018-08-25
	%	Copyright:			by authors - not released for commercial use
	% 	Version:			1	 
	% 	Known bugs:			
	% 	Report bugs to:		Wanhammar@gmail.com
	
	s = size(vals);
	vals = reshape(vals,s(1)*s(2),1);
	c = 1;
	while any(abs(vals) > 2/3)
		vals = vals/2;
		c = c+1;
	end

	csdc = TWO_V_2_CSDC_V(REAL_V_2_TWOC_V(vals,c));	
